/* - ANAttachListener -
 * populate the fields and controls
 *
 * Copyright 2011 Phidgets Inc.
 * This work is licensed under the Creative Commons Attribution 2.5 Canada License.
 * To view a copy of this license, visit http://creativecommons.org/licenses/by/2.5/ca/
 */
package listeners;

import com.phidgets.GPSPhidget;
import com.phidgets.PhidgetException;
import com.phidgets.event.AttachListener;
import com.phidgets.event.AttachEvent;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JCheckBox;

import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class GAttachListener implements AttachListener {

    private JFrame appFrame;
    private JPanel gpsPanel;
    private JTextField attachedTxt;
    private JTextArea nameTxt;
    private JTextField serialTxt;
    private JTextField versionTxt;
    private JCheckBox fixStatusChk;
    private JTextField dateTxt;
    private JTextField timeTxt;
    private JTextField latTxt;
    private JTextField longTxt;
    private JTextField altTxt;
    private JTextField velTxt;
    private JTextField headTxt;

    public GAttachListener(JFrame appFrame, JPanel gpsPanel, JTextField attachedTxt, JTextArea nameTxt,
            JTextField serialTxt, JTextField versionTxt, JCheckBox fixStatusChk, JTextField dateTxt,
            JTextField timeTxt, JTextField latTxt, JTextField longTxt, JTextField altTxt, JTextField velTxt,
            JTextField headTxt) {

        this.appFrame = appFrame;
        this.gpsPanel = gpsPanel;
        this.attachedTxt = attachedTxt;
        this.nameTxt = nameTxt;
        this.serialTxt = serialTxt;
        this.versionTxt = versionTxt;

        this.fixStatusChk = fixStatusChk;
        this.dateTxt = dateTxt;
        this.timeTxt = timeTxt;
        this.latTxt = latTxt;
        this.longTxt = longTxt;
        this.altTxt = altTxt;
        this.velTxt = velTxt;
        this.headTxt = headTxt;
    }

    public void attached(AttachEvent an) {
        try {
            appFrame.setSize(357, 590);

            final GPSPhidget attached = (GPSPhidget) an.getSource();
            attachedTxt.setText(Boolean.toString(attached.isAttached()));
            nameTxt.setText(attached.getDeviceName());
            serialTxt.setText(Integer.toString(attached.getSerialNumber()));
            versionTxt.setText(Integer.toString(attached.getDeviceVersion()));

            gpsPanel.setEnabled(true);
            gpsPanel.setVisible(true);

            fixStatusChk.setEnabled(true);
            dateTxt.setEnabled(true);
            timeTxt.setEnabled(true);
            latTxt.setEnabled(true);
            longTxt.setEnabled(true);
            altTxt.setEnabled(true);
            velTxt.setEnabled(true);
            headTxt.setEnabled(true);

            int startTime = 0;
            int delayTime = 100; //milliseconds
            Timer timer = new Timer();
            timer.schedule(new TimerTask() {

                public void run() {

                    Calendar cal;
                    try {
                        cal = attached.getDateAndTime();
                        DateFormat dateFormat = new SimpleDateFormat("E dd/MM/yyyy");
                        timeTxt.setText(dateFormat.format(cal.getTime()));
                        DateFormat timeFormat = new SimpleDateFormat("HH:mm:ss.SSS z");
                        dateTxt.setText(timeFormat.format(cal.getTime()));
                    } catch (PhidgetException ex) {
                    }
                }
            }, startTime, delayTime);

        } catch (PhidgetException ex) {
            JOptionPane.showMessageDialog(appFrame, ex.getDescription(), "Phidget error " + ex.getErrorNumber(), JOptionPane.ERROR_MESSAGE);
        }
    }
}
